<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Model;

use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\Model\Entities\OrderItem;
use Nette\Localization\Translator;

class OrdersItem
{
	protected EntityManagerDecorator $em;
	protected Translator             $translator;

	public function __construct(
		EntityManagerDecorator $em,
		Translator             $translator
	)
	{
		$this->em         = $em;
		$this->translator = $translator;
	}

	public function changePrice(int $orderId, int $itemId, float $price): bool
	{
		/** @var ?OrderItem $orderItem */
		$orderItem = $this->em->getRepository(OrderItem::class)->findOneBy([
			'order' => $orderId,
			'id'    => $itemId,
		]);

		if (!$orderItem) {
			return false;
		}

		try {
			$orderItem->setPrice($price);
			$this->em->persist($orderItem);
			$this->em->flush();

			return true;
		} catch (\Exception $e) {
		}

		return false;
	}

	public function changeQuantity(int $orderId, int $itemId, int $quantity): bool
	{
		/** @var ?OrderItem $orderItem */
		$orderItem = $this->em->getRepository(OrderItem::class)->findOneBy([
			'order' => $orderId,
			'id'    => $itemId,
		]);

		if (!$orderItem) {
			return false;
		}

		try {
			$orderItem->setQuantity($quantity);
			$this->em->persist($orderItem);
			$this->em->flush();

			return true;
		} catch (\Exception $e) {
		}

		return false;
	}

	public function removeItem(int $orderId, int $itemId): bool
	{
		/** @var ?OrderItem $orderItem */
		$orderItem = $this->em->getRepository(OrderItem::class)->findOneBy([
			'order' => $orderId,
			'id'    => $itemId,
		]);

		if (!$orderItem) {
			return false;
		}

		try {
			$this->em->remove($orderItem);
			$this->em->flush();

			return true;
		} catch (\Exception $e) {
		}

		return false;
	}
}
