<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class UpdatedCartItemEvent extends Event
{
	public $itemId;

	/** @var int */
	public $quantity;

	public ?int $productId = null;

	public int $beforeQuantity;

	public array $moreData;

	public function __construct($itemId, int $quantity, int $beforeQuantity, array $moreData = [], ?int $productId = null)
	{
		$this->itemId         = $itemId;
		$this->quantity       = $quantity;
		$this->beforeQuantity = $beforeQuantity;
		$this->moreData       = $moreData;
		$this->productId      = $productId;
	}
}
