<?php declare(strict_types=1);


namespace EshopOrders\Model;

use Contributte\Scheduler\Helpers\Debugger;
use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\OrderItem;
use Exception;

/**
 * class OrderItems
 * @package EshopOrders\Model
 *
 * @method OrderItem|object|null getReference($id)
 * @method OrderItem[]|null getAll()
 * @method OrderItem|null get($id)
 */
class OrderItems extends BaseEntityService
{
	protected $entityClass = OrderItem::class;

	public function setReadyToDelivery(int $id, int $value): bool
	{
		try {
			$oi = $this->get($id);

			if (!$oi) {
				return false;
			}

			$oi->isReadyToDelivery = $value;
			$this->em->persist($oi);
			$this->em->flush($oi);

			return true;
		} catch (Exception $e) {
			Debugger::log($e);
			return false;
		}
	}
	
}
