<?php declare(strict_types = 1);

namespace EshopOrders\Model;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\Query;
use EshopCatalog\Model\Config;
use EshopCatalog\Model\Entities\ProductPriceLevel;
use EshopOrders\Model\Entities\Payment;
use EshopOrders\Model\Helpers\EshopOrdersCache;
use Nette\Caching\Cache;

/**
 * @method ProductPriceLevel|object|null getReference($id)
 * @method ProductPriceLevel|null get($id)
 */
class ProductsPriceLevel extends BaseEntityService
{
	protected $entityClass = ProductPriceLevel::class;

	protected EshopOrdersCache $eshopOrdersCache;

	public function __construct(
		EshopOrdersCache $eshopOrdersCache
	)
	{
		$this->eshopOrdersCache = $eshopOrdersCache;
	}

	public function getPricesForGroup(array $ids, int $groupId): array
	{
		$arr = [];

		foreach (array_chunk($ids, 500) as $chunk) {
			$query = $this->em->getRepository(ProductPriceLevel::class)->createQueryBuilder('ppl')
				->select('IDENTITY(ppl.productId) as product, ppl.price')
				->where('ppl.productId IN (' . implode(',', array_values($chunk)) . ')')
				->andWhere('ppl.groupId = :groupId')
				->setParameters([
					'groupId' => $groupId,
				])
				->getQuery();

			if (Config::load('productsList.enableFreshResultCache')) {
				$query->enableResultCache(Config::load('productsList.enableFreshResultCache'));
			}

			foreach ($query->getArrayResult() as $row) {
				$arr[$row['product']] = (float) $row['price'];
			}
		}

		return $arr;
	}
}
