<?php declare(strict_types=1);

namespace EshopOrders\Model\Templating\Filters;

use EshopOrders\Model\Entities\IDiscount;
use EshopOrders\Model\Utils\Helpers;

class DiscountFilter
{
	/** @var Helpers */
	protected $helpers;

	/**
	 * OrderDiscountFilter constructor.
	 * @param Helpers $helpers
	 */
	public function __construct(Helpers $helpers)
	{
		$this->helpers = $helpers;
	}

	/**
	 * @param IDiscount $discount
	 * @return string
	 */
	public function __invoke(IDiscount $discount): string
	{
		return $this->helpers->formatDiscount($discount);
	}

}