<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\Payment;

/**
 * @method Payment|object|null getReference($id)
 * @method Payment[]|null getAll()
 * @method Payment|null get($id)
 */
class Payments extends BaseEntityService
{
	protected $entityClass = Payment::class;

	protected $cForSelectOption;

	public function getForSelectOption(): array
	{
		if ($this->cForSelectOption === null)
			$this->cForSelectOption = [null => ''] + ($this->getEr()->findPairs([], 'name') ?: []);

		return $this->cForSelectOption;
	}
}
