<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderStatus;
use EshopOrders\Model\Entities\Status;
use Users\Model\Entities\User;
use Users\Model\Http\UserStorage;

/**
 * @method Status|object|null getReference($id)
 * @method Status[]|null getAll()
 * @method Status|null get($id)
 */
class Statuses extends BaseEntityService
{
	protected $entityClass = Status::class;

	protected $cForSelectOption;

	/** @var UserStorage */
	protected $userStorage;

	public function __construct(UserStorage $userStorage)
	{
		$this->userStorage = $userStorage;
	}


	public function changeStatus(array $ids, string $status): bool
	{
		$status = $this->getReference($status);

		if (!$status)
			return false;

		$this->em->beginTransaction();
		try {
			foreach ($ids as $id) {
				$entity = new OrderStatus(
					$this->em->getReference(Order::class, $id),
					$status,
					$this->em->getReference(User::class, $this->userStorage->getIdentity()->getId()),
				);
				$this->em->persist($entity);
			}
			$this->em->flush();
			$this->em->commit();
		} catch (\Exception $e) {
			if ($this->em->getConnection()->isTransactionActive())
				$this->em->rollback();

			return false;
		}

		return true;
	}

	public function getForSelectOption(): array
	{
		if ($this->cForSelectOption === null)
			$this->cForSelectOption = [null => ''] + ($this->getEr()->findPairs([], 'name') ?: []);

		return $this->cForSelectOption;
	}
}
