<?php declare(strict_types=1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Components\Invoice\IInvoiceConfigFormFactory;
use EshopOrders\AdminModule\Components\Invoice\IInvoicesGridFactory;
use EshopOrders\AdminModule\Components\Invoice\InvoiceConfigForm;
use EshopOrders\AdminModule\Components\Invoice\InvoicesGrid;
use Nette\Application\UI\InvalidLinkException;

class InvoicePresenter extends BasePresenter
{
	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	/**
	 * @throws InvalidLinkException
	 */
	public function actionDefault(): void
	{
		$this->setHeader('eshopOrders.title.invoices', 'fa fa-shopping-cart');

		// orders navigation item
		$navigation[] = [
			'title' => 'eshopOrders.menu.orders',
			'link'  => $this->link('Default:default'),
			'ico'   => 'fa fa-shopping-cart'
		];

		// invoice settings navigation item
		$navigation[] = [
			'title' => 'eshopOrders.menu.invoiceSettings',
			'link'  => $this->link('invoiceSettings'),
			'ico'   => 'fas fa-cogs'
		];

		$this['navigation']->setData(['header' => $navigation]);
	}

	public function actionInvoiceSettings(): void
	{
		$this->setHeader('eshopOrders.title.invoiceSettings', 'fas fa-cogs');

		// orders navigation item
		$navigation[] = [
			'title' => 'eshopOrders.menu.orders',
			'link'  => $this->link('Default:default'),
			'ico'   => 'fa fa-shopping-cart'
		];

		// invoices navigation item
		$navigation[] = [
			'title' => 'eshopOrders.menu.invoices',
			'link'  => $this->link('Invoice:default'),
			'ico'   => 'fas fa-file-invoice-dollar'
		];

		$this['navigation']->setData(['header' => $navigation]);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	/**
	 * @param IInvoicesGridFactory $factory
	 * @return InvoicesGrid
	 */
	public function createComponentInvoicesGrid(IInvoicesGridFactory $factory): InvoicesGrid
	{
		return $factory->create();
	}

	/**
	 * @param IInvoiceConfigFormFactory $factory
	 * @return InvoiceConfigForm
	 */
	public function createComponentInvoiceConfigForm(IInvoiceConfigFormFactory $factory): InvoiceConfigForm
	{
		return $factory->create();
	}

}