<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Presenters;

use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Orders;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Model\TrackingHelper;
use EshopOrders\FrontModule\Components\Order\IOrderTrackingFactory;

class FinishedPresenter extends BasePresenter
{
	/** @persistent */
	public $orderIdent;

	/** @var Orders */
	protected $ordersService;
	
	/** @var TrackingHelper */
	protected $trackingHelperService;

	/** @var Order */
	protected $order;

	public function __construct(Orders $orders, TrackingHelper $trackingHelper)
	{
		$this->ordersService = $orders;
		
		$this->trackingHelperService = $trackingHelper;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionOrderFinished()
	{
		if ($this->getParameter('orderIdent')) {
			$this->order = $this->ordersService->getByIdent($this->getParameter('orderIdent'));
		}
	}

	/*******************************************************************************************************************
	 * ============================== Renders
	 */

	public function renderOrderFinished()
	{
		if ($this->order) {
			$this->template->order = $this->order;
			
			if($this->trackingHelperService->canSend('gtmRemarketing')) {
				$this->setOrderRemarketing();
				$this->trackingHelperService->send('gtmRemarketing');
			}
		}

		//flash zpravy zobrazime v textu, ne jako prekryvne
		$paymentType                      = $this->order ? $this->order->getPayment()->getPayment()->getIdent() : null;
		$this->template->paymentType      = $paymentType;
		$this->template->useOrderTracking = $this->order && !in_array($paymentType, ['card', 'essox']);
		$this->template->messages         = $this->getTemplate()->flashes;
		$this->getTemplate()->flashes     = [];
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentOrderTracking(IOrderTrackingFactory $factory)
	{
		$control = $factory->create();
		if ($this->getParameter('orderIdent')) {
			$control->setOrder($this->getParameter('orderIdent'));
		}

		return $control;
	}
	
	/*******************************************************************************************************************
	 * ============================== Other
	 */
	
	public function setOrderRemarketing()
	{
		$items = [];
		foreach ($this->order->getOrderItems() as $item) {
			$items[] = [
				'id' => $item->getProductId(),
				'google_business_vertical' => 'retail',
			];
		}
		
		
		$gtmRemarketingData = [
			'event' => 'purchase',
			'value' => $this->order->getPriceItems(),
			'items' => $items
		];
		$this['gtmRemarketing']->setData($gtmRemarketingData);
	}
}
