<?php declare(strict_types=1);

namespace EshopOrders\Model;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\QueryBuilder;
use EshopOrders\Model\Entities\Invoice;
use Kdyby\Doctrine\Dql\Join;

/**
 * Class Invoices
 * @package EshopOrders\Model
 *
 * @method Invoice|null get($id)
 */
class Invoices extends BaseEntityService
{
	/** @var string */
	protected $entityClass = Invoice::class;

	/**
	 * @return QueryBuilder
	 */
	public function getQueryBuilder(): QueryBuilder
	{
		return $this->getEr()->createQueryBuilder('i')->orderBy('i.ident', 'desc');
	}

	/**
	 * @param int $orderId
	 * @return Invoice|null
	 * @throws NonUniqueResultException
	 */
	public function getOneByOrder(int $orderId): ?Invoice
	{
		$qb = $this->em->createQueryBuilder();
		$qb->select('i')
		   ->from(Invoice::class, 'i')
		   ->join('i.order', 'o', Join::WITH, 'o.invoice = i.id')
		   ->where('o.id = :orderId')
		   ->setParameter('orderId', $orderId);

		return $qb->getQuery()->getOneOrNullResult();
	}

	/**
	 * @return int
	 * @throws NonUniqueResultException
	 */
	public function getIvoicesCount(): int
	{
		$qb = $this->getQueryBuilder();
		return (int) $qb->select($qb->expr()->count('i.id'))->getQuery()->getSingleScalarResult();
	}

}