<?php declare(strict_types=1);

namespace EshopOrders\Model\Templating\Filters;

use EshopOrders\Model\Entities\OrderDiscount;
use EshopOrders\Model\Utils\Helpers;

class OrderDiscountFilter
{
	/** @var Helpers */
	protected $helpers;

	/**
	 * OrderDiscountFilter constructor.
	 * @param Helpers $helpers
	 */
	public function __construct(Helpers $helpers)
	{
		$this->helpers = $helpers;
	}

	/**
	 * @param OrderDiscount $discount
	 * @return string
	 */
	public function __invoke(OrderDiscount $discount): string
	{
		return $this->helpers->formatDiscount($discount);
	}

}