<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table("eshop_orders__order_item_gift")
 * @ORM\Entity
 */
class OrderItemGift
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @ORM\ManyToOne(targetEntity="OrderItem", inversedBy="gifts")
	 * @ORM\JoinColumn(name="order_item_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $orderItem;

	/**
	 * @var Product
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	protected $product;

	/**
	 * @var string
	 * @ORM\Column(name="code1", type="string", length=60, nullable=true)
	 */
	public $code1;

	/**
	 * @var string
	 * @ORM\Column(name="ean", type="string", length=20, nullable=true)
	 */
	public $ean;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", nullable=false)
	 */
	protected $name;

	public function __construct(OrderItem $orderItem, Product $product, string $name)
	{
		$this->orderItem = $orderItem;
		$this->product   = $product;
		$this->name      = $name;
		$orderItem->addGift($this);
	}

	public function getOrderItem(): OrderItem { return $this->orderItem; }

	public function getName(): string { return $this->name; }
}
