<?php declare(strict_types = 1);

namespace EshopOrders\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\Payment;

/**
 * class Payments
 * @package EshopOrders\Model
 * 
 * @method Payment|object|null getReference($id)
 * @method Payment|null get($id)
 */
class Payments extends BaseEntityService
{
	protected $entityClass = Payment::class;
	
	public function setPosition($id, $position)
	{
		if ($item = $this->get($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();
			
			return true;
		}
		
		return false;
	}
	
	public function setPublish($id, $state)
	{
		if ($item = $this->getReference($id)) {
			$item->isPublished = $state;
			$this->em->persist($item);
			$this->em->flush();
			
			return true;
		}
		
		return false;
	}
	
	public function getAll()
	{
		$paymentsQuery = $this->getEr()->createQueryBuilder('p', 'p.id');
		$paymentsQuery->orderBy('p.position');
		$payments = $paymentsQuery->getQuery()->getResult();
		
		return $payments;
	}
	
	public function getAllPublished()
	{
		$paymentsQuery = $this->getEr()->createQueryBuilder('p', 'p.id');
		$paymentsQuery->andWhere('p.isPublished = :isPublished')->setParameter('isPublished', true);
		$paymentsQuery->orderBy('p.position');
		$payments = $paymentsQuery->getQuery()->getResult();
		
		return $payments;
	}
	
	/**
	 * @param int $cartValue cena objednavky
	 * @return Dao\Payment[] vsechny dopravy, ktere jsou aktivni, a jsou dostupne pro danou cenu objednavky
	 */
	public function getAllByCartValue($cartValue)
	{
		$paymentsQuery = $this->getEr()->createQueryBuilder('p', 'p.id');
		$paymentsQuery->andWhere('p.isPublished = :isPublished')->setParameter('isPublished', true);
		$paymentsQuery->andWhere('p.availableFrom IS NULL OR p.availableFrom <= :cartValue')->setParameter('cartValue', $cartValue);
		$paymentsQuery->andWhere('p.availableTo IS NULL OR p.availableTo >= :cartValue')->setParameter('cartValue', $cartValue);
		$paymentsQuery->orderBy('p.position');
		$payments = $paymentsQuery->getQuery()->getResult();
		
		return $payments;
	}
}
