<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Cart;

use Core\Model\Event\ComponentTemplateEvent;
use EshopOrders\FrontModule\Components\Discount\DiscountForm;
use EshopOrders\FrontModule\Model\CartFacade;
use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Components\Discount\IDiscountFormFactory;
use Nette\Application\UI\Multiplier;

class CartDetail extends BaseControl
{
	/** @var CartFacade */
	protected $cartFacade;

	/** @var ICartDetailItemFactory */
	protected $cartDetailItemFactory;

	/** @var IDiscountFormFactory */
	protected $discountFormFactory;

	public function __construct(CartFacade $cartFacade, ICartDetailItemFactory $factory, IDiscountFormFactory $discountFormFactory)
	{
		$this->cartFacade            = $cartFacade;
		$this->cartDetailItemFactory = $factory;
		$this->discountFormFactory   = $discountFormFactory;
	}

	protected function attached($presenter)
	{
		parent::attached($presenter);

		$this->eventDispatcher->addListener('eshopOrders.cartUpdateItem', function() {
			$cart = $this->cartFacade->getCart();

			if ($cart->getItemsCount())
				$this->redrawControl('wrap');
			else
				$this->getPresenter()->redrawControl('cart');
		});
	}


	public function render(): void
	{
		$cart                 = $this->cartFacade->getCart();
		$this->template->cart = $cart;

		$freeSped                               = $this->cartFacade->countFreeSpedition();
		$this->template->freeSpeditionPrice     = $freeSped['minPrice'];
		$this->template->freeSpeditionRemaining = $freeSped['remaining'];

		$this->eventDispatcher->dispatch('eshopOrders.cartDetail.render', new ComponentTemplateEvent($this->template, $this));

		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ======================== Components
	 */

	protected function createComponentCartDetailItem(): Multiplier
	{
		return new Multiplier(function($item) {
			$control = $this->cartDetailItemFactory->create();
			$control->setItem((int) $item);

			return $control;
		});
	}

	protected function createComponentDiscountForm(): DiscountForm
	{
		$control = $this->discountFormFactory->create();

		return $control;
	}
}

