<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table("eshop_orders__spedition")
 * @ORM\Entity
 */
class Spedition
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string")
	 */
	protected $name;

	/**
	 * @var string
	 * @ORM\Column(name="ident", type="string")
	 */
	protected $ident;

	/**
	 * @var string
	 * @ORM\Column(name="text", type="string")
	 */
	protected $text;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint")
	 */
	public $isPublished;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	protected $position;

	/**
	 * @var int
	 * @ORM\Column(name="price", type="smallint")
	 */
	protected $price;

	/**
	 * @var int
	 * @ORM\Column(name="free_from", type="integer", nullable=true)
	 */
	protected $freeFrom;

	/**
	 * @var int
	 * @ORM\Column(name="available_from", type="integer", nullable=true)
	 */
	protected $availableFrom;

	/**
	 * @var int
	 * @ORM\Column(name="available_to", type="integer", nullable=true)
	 */
	protected $availableTo;

	/**
	 * @var string
	 * @ORM\Column(name="image", type="string", nullable=true, length=255)
	 */
	public $image;

	/** TODO pridat pridruzenou tabulku "externi id" kde bude uvedeny kod dopravce pro Zbozi.cz
	 * @var string
	 * @ORM\Column(name="zbozi_id", type="string", nullable=true, length=255)
	 */
	public $zboziId;

	/**
	 * Member constructor.
	 */
	public function __construct()
	{
		$this->isPublished = 1;
		$this->setPosition(-1);
		$this->freeFrom = 999999;
	}

	public function getName()
	{
		return $this->name;
	}

	public function getText()
	{
		return $this->text;
	}

	public function getPosition()
	{
		return $this->position;
	}

	public function getPrice()
	{
		return $this->price;
	}

	public function setName($name)
	{
		$this->name = $name;

		return $this;
	}

	public function setText($text)
	{
		$this->text = $text;

		return $this;
	}

	public function setPosition($position)
	{
		$this->position = intval($position);

		return $this;
	}

	public function setPrice(int $price): self
	{
		$this->price = $price;

		return $this;
	}

	/*******
	 * === Ident
	 */

	public function getIdent()
	{
		return $this->ident;
	}

	public function setIdent($ident): Spedition
	{
		$this->ident = $ident;

		return $this;
	}

	/*******
	 * === FreeFrom
	 */

	public function getFreeFrom()
	{
		return $this->freeFrom;
	}

	public function setFreeFrom(int $freeFrom): Spedition
	{
		$this->freeFrom = $freeFrom;

		return $this;
	}

	/*******
	 * === AvailableFrom
	 */

	public function getAvailableFrom()
	{
		return $this->availableFrom;
	}

	public function setAvailableFrom(int $availableFrom): Spedition
	{
		$this->availableFrom = $availableFrom;

		return $this;
	}

	/*******
	 * === AvailableTo
	 */

	public function getAvailableTo()
	{
		return $this->availableTo;
	}

	public function setAvailableTo(int $availableTo): Spedition
	{
		$this->availableTo = $availableTo;

		return $this;
	}

	/*******
	 * === ZboziId
	 */

	public function getZboziId()
	{
		return $this->zboziId;
	}

	public function setZboziId($zboziId): Spedition
	{
		$this->zboziId = $zboziId;

		return $this;
	}
}
