<?php declare(strict_types=1);

namespace EshopOrders\AdminModule\Components\Order;

use Contributte\Scheduler\Helpers\Debugger;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderDiscount;
use Nette\Utils\ArrayHash;

class OrderDiscountForm extends BaseControl
{
	protected Order $order;

	public function __construct(Order $order)
	{
		$this->order = $order;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax()
			 ->setShowLangSwitcher(false);

		$form->addText('name', 'eshopOrders.orderDiscountForm.name')
			 ->setNullable();
		$form->addText('value', 'eshopOrders.orderDiscountForm.value')
			 ->setRequired()
			 ->addRule($form::FLOAT);
		$form->addSelect('saleType', null, [OrderDiscount::TYPE_PERCENT => '%', OrderDiscount::TYPE_FIX => 'Kč'])
			 ->setRequired();

		$form->addSaveCancelControl();
		unset($form['saveControl']['save']);

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		try {
			$saleEntity = new OrderDiscount('', $this->order);
			$saleEntity->setName($values->name ?? '');
			$values->value = (float) $values->value;
			$totalPrice = $this->order->getPriceItems(true);

			if ($values->saleType === OrderDiscount::TYPE_PERCENT) {
				$price = $totalPrice * ($values->value / 100);
				$saleEntity->setPrice($price);
			} else if ($values->saleType === OrderDiscount::TYPE_FIX) {
				$saleEntity->setPrice($values->value);
			}

			$saleEntity->setValue($values->value);
			$saleEntity->setType($values->saleType);

			$this->em->persist($saleEntity);
			$this->em->flush();

			$this->getPresenter()->flashMessageSuccess('default.saved');
		} catch (\Exception $exception) {
			Debugger::log($exception);
			$this->getPresenter()->flashMessageSuccess('default.error');
		}

	}

}