<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use EshopOrders\Model\Entities\GroupCustomers;
use EshopOrders\Model\Helpers\CustomersCache;
use EshopOrders\Model\Helpers\CustomersCacheHelper;

class GroupsCustomers extends BaseEntityService
{
	use TPublish;

	protected $entityClass = GroupCustomers::class;

	protected ?array $cOptionsForSelect      = null;
	protected ?array $cOptionsForSelectShort = null;

	protected CustomersCache $customersCache;

	public function __construct(
		CustomersCache $customersCache
	)
	{
		$this->customersCache = $customersCache;
	}

	public function getOptionsForSelect(): array
	{
		if ($this->cOptionsForSelect === null) {
			$this->cOptionsForSelect      = [];
			$this->cOptionsForSelectShort = [];


			foreach ($this->getEr()->createQueryBuilder('gc')
				         ->select('gc.id, gc.short, gc.name')
				         ->getQuery()->getArrayResult() as $row) {
				$this->cOptionsForSelect[$row['id']]      = $row['name'];
				$this->cOptionsForSelectShort[$row['id']] = $row['short'];
			}
		}

		return $this->cOptionsForSelect;
	}

	public function getOptionsForSelectShort(): array
	{
		if ($this->cOptionsForSelectShort === null) {
			$this->getOptionsForSelect();
		}

		return $this->cOptionsForSelectShort;
	}

	public function remove($id)
	{
		$result = parent::remove($id);

		$this->customersCache->getCache()->remove(CustomersCacheHelper::getCustomerGroupKey((int) $id));

		return $result;
	}
}
