<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Apitte\Negotiation\Http\ArrayEntity;
use EshopOrders\FrontModule\Model\CartFacade;
use Apitte\Core\Annotation\Controller\RequestBody;

/**
 * @Path("/cart")
 */
class CartController extends BaseController
{
	protected CartFacade $cartFacade;

	public function __construct(
		CartFacade $cartFacade
	)
	{
		$this->cartFacade = $cartFacade;
	}

	/**
	 * @Path("/item")
	 * @Method("POST")
	 * @RequestBody(entity="EshopOrders\ApiModule\Api\V1\BodyEntity\CartItem")
	 */
	public function addItem(ApiRequest $request, ApiResponse $response)
	{
		$data = $request->getEntity();
		bdump($data);

		die();

		return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from($customers));
	}
}
