<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use EshopOrders\FrontModule\Model\Dao\Cart;
use EshopOrders\Model\EshopOrdersConfig;
use EshopOrders\Model\PaymentSpeditions;

class CartFacade
{
	protected Carts             $carts;
	protected Speditions        $speditions;
	protected Payments          $payments;
	protected PaymentSpeditions $paymentSpeditions;
	protected CartHelper        $cartHelper;

	public function __construct(
		Carts             $carts,
		Speditions        $speditions,
		Payments          $payments,
		PaymentSpeditions $paymentSpeditions,
		CartHelper        $cartHelper
	)
	{
		$this->carts             = $carts;
		$this->speditions        = $speditions;
		$this->payments          = $payments;
		$this->paymentSpeditions = $paymentSpeditions;
		$this->cartHelper        = $cartHelper;
	}

	public function getCart(): Cart
	{
		$cart = $this->carts->getCurrentCart();

		$this->paymentSpeditions->cart = $cart;

		$formData = $this->getOrderFormData();
		if ($formData) {
			if ($formData['spedition'] && $v = $this->speditions->get($formData['spedition']))
				$cart->setSpedition($v);
			if ($formData['payment'] && $v = $this->payments->get($formData['payment']))
				$cart->setPayment($v);

			if ($cart->spedition && $cart->payment)
				$cart->payment->vat = $cart->spedition->vat;
		}

		if (EshopOrdersConfig::load('allowFreeFrom') && $cart->spedition && $cart->spedition->price > 0) {
			$freeCombinations = [];
			foreach ($this->paymentSpeditions->getAllPublishedByCountry($formData ? $formData['speditionCountry'] : null) as $ps) {
				if ($ps->isFreeCombination())
					$freeCombinations[] = $ps;
			}
			$cart->paymentSpeditionFreeCombinations = $freeCombinations;
		}

		return $cart;
	}

	public function getCartsService(): Carts { return $this->carts; }

	public function getOrderFormData(): array { return $this->cartHelper->getOrderFormData(); }

	public function countFreeSpedition(): ?array { return $this->cartHelper->countFreeSpedition(); }

	public function countFreeSpeditionMilestones(): ?array { return $this->cartHelper->countFreeSpeditionMilestones(); }
}
