<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use Core\Model\Application\AppState;
use EshopOrders\Model\Entities\IDiscount;

class Discount implements IDiscount
{

	/** @var string */
	public $id;

	/** @var string */
	public $title;

	/** @var float */
	public $amount;

	/** @var float */
	public $amountInBaseCurrency;

	public float $discountInBaseCurrency = 0;
	public float $discount               = 0;

	/** @var string */
	public $type;

	/** @var string */
	public $typeSymbol = '';

	/** @var string */
	public $packageType;

	public ?string $text = null;

	public $calculateDiscountCallback = null;

	public function __construct(string $id, float $amount, string $type, string $packageType)
	{
		$this->id          = $id;
		$this->amount      = $amount;
		$this->type        = $type;
		$this->packageType = $packageType;
	}

	public function calculateDiscount(bool $useBaseCurrency = false): float
	{
		if (is_callable($this->calculateDiscountCallback)) {
			return call_user_func($this->calculateDiscountCallback, $this, $useBaseCurrency);
		}

		return round($useBaseCurrency ? $this->discountInBaseCurrency : $this->discount, (int) AppState::getState('eshopOrdersCartDecimals', 0));
	}

	/**
	 * @return float
	 */
	public function getValue(): float
	{
		return $this->amount;
	}

	/**
	 * @return string
	 */
	public function getType(): string
	{
		return $this->type;
	}
}



