<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use Core\Model\Dao\Country;
use Nette\Utils\DateTime;

class PaymentSpedition
{
	/** @var int */
	protected int $id;

	/** @var Payment */
	protected Payment $payment;

	/** @var Spedition */
	protected Spedition $spedition;

	public ?\DateTimeInterface $freeFromDate = null;

	public ?\DateTimeInterface $freeToDate = null;

	/** @var Country[] */
	protected array $countries = [];

	public ?string $currency = null;

	public function __construct(int $id, Payment $payment, Spedition $spedition)
	{
		$this->id        = $id;
		$this->payment   = $payment;
		$this->spedition = $spedition;
	}

	/**
	 * @return int
	 */
	public function getId(): int { return $this->id; }

	/**
	 * @return Payment
	 */
	public function getPayment(): Payment { return $this->payment; }

	/**
	 * @return Spedition
	 */
	public function getSpedition(): Spedition { return $this->spedition; }

	/**
	 * @return array|Country[]
	 */
	public function getCountries(): array { return $this->countries; }

	/**
	 * @param array $countries
	 */
	public function setCountries(array $countries): void
	{
		$this->countries = $countries;
	}

	/**
	 * @param string  $key
	 * @param Country $country
	 */
	public function addCountry(string $key, Country $country): void
	{
		$this->countries[$key] = $country;
	}

	public function isFreeCombination()
	{
		$today = (new DateTime())->getTimestamp();

		return $this->freeFromDate && $today >= $this->freeFromDate->getTimestamp()
			&& (!$this->freeToDate || $today <= $this->freeToDate->getTimestamp());
	}
}
