<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20230126094851 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE eshop_orders__order ADD last_status VARCHAR(255) DEFAULT NULL');
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$used = [];
		foreach ($this->connection->fetchAllAssociative("SELECT os.id, os.status_id, os.order_id FROM eshop_orders__order_status os ORDER BY os.created DESC") as $row) {
			if (isset($used[$row['order_id']])) {
				continue;
			}

			$this->connection->executeQuery("UPDATE eshop_orders__order SET last_status = ? WHERE id = ?", [
				$row['status_id'], $row['order_id'],
			]);

			$used[$row['order_id']] = $row['id'];
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE eshop_orders__order DROP last_status');
	}
}
