const form = document.querySelector('.orderItemForm');

if (form) {
	const priceControl        = form.querySelector('[name="price"]');
	const currencyRateControl = form.querySelector('[name="currencyPrice"]');
	if (currencyRateControl && priceControl) {
		let rate = currencyRateControl.dataset.rate;

		if (rate) {
			rate = rate.replace(',', '.');
			rate = parseFloat(rate);

			function updatePrice() {
				let price = priceControl.value.replace(',', '.');
				price     = parseFloat(price);

				currencyRateControl.value = Math.round((price / rate) * 100) / 100;
			}

			priceControl.addEventListener('change', updatePrice);
			priceControl.addEventListener('keyup', updatePrice);
			updatePrice();
		}
	}
}
