<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Affiliate;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Query\Parameter;
use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use Doctrine\ORM\Query\Expr\Join;
use EshopOrders\AdminModule\Model\AffiliateCampaigns;
use EshopOrders\AdminModule\Model\AffiliateOrders;
use EshopOrders\AdminModule\Model\AffiliatePartners;
use EshopOrders\Model\Entities\Affiliate\AffiliateCampaignStat;

class PartnersStatsGrid extends BaseControl
{
	public function __construct(
		protected int                $partnerId,
		protected AffiliatePartners  $affiliatePartners,
		protected AffiliateCampaigns $affiliateCampaigns,
		protected AffiliateOrders    $affiliateOrders,
	)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();

		$data         = [];
		$campaignsIds = [];
		foreach ($this->affiliateOrders->getEr()->createQueryBuilder('ao')
			         ->select('ao.value, ao.orderValue, ao.created, IDENTITY(ao.campaign) as campaign')
			         ->innerJoin('ao.campaign', 'ac')
			         ->innerJoin('ac.partner', 'ap', Join::WITH, 'ap.id = :partnerId')
			         ->andWhere('ao.cancelled IS NULL')
			         ->setParameters(new ArrayCollection([new Parameter('partnerId', $this->partnerId)]))
			         ->orderBy('ao.created', 'DESC')
			         ->getQuery()->getArrayResult() as $row) {
			$date                           = $row['created']->format('Y-m-d');
			$campaignsIds[$row['campaign']] = $row['campaign'];

			if (!isset($data[$date])) {
				$data[$date] = [
					'date'        => $date,
					'orders'      => 0,
					'ordersValue' => 0,
					'clicks'      => 0,
					'commission'  => 0,
				];
			}

			$data[$date]['orders']++;
			$data[$date]['ordersValue'] += $row['orderValue'];
			$data[$date]['commission']  += $row['value'];
		}

		foreach (array_chunk($campaignsIds, 250) as $chunk) {
			foreach ($this->em->getRepository(AffiliateCampaignStat::class)->createQueryBuilder('s')
				         ->select('s.date, s.clicks')
				         ->where('s.campaign IN (' . implode(',', $chunk) . ')')
				         ->orderBy('s.date', 'DESC')
				         ->getQuery()
				         ->getScalarResult() as $row) {
				$date = $row['date'];

				if (!isset($data[$date])) {
					$data[$date] = [
						'date'        => $date,
						'orders'      => 0,
						'ordersValue' => 0,
						'clicks'      => 0,
						'commission'  => 0,
					];
				}

				$data[$date]['clicks'] += $row['clicks'];
			}
		}

		krsort($data);

		$grid->setDataSource($data);

		//Columns
		$grid->addColumnText('date', 'eshopOrders.affiliate.date');
		$grid->addColumnNumber('clicks', 'eshopOrders.affiliate.clicks');
		$grid->addColumnNumber('orders', 'eshopOrders.affiliate.orders');
		$grid->addColumnPrice('ordersValue', 'eshopOrders.affiliate.ordersValue');
		$grid->addColumnPrice('commission', 'eshopOrders.affiliate.commission');

		// Columns prototype
		$grid->getColumn('date')->getElementPrototype('th')->addClass('w1nw');
		$grid->getColumn('date')->getElementPrototype('td')->addClass('w1nw');

		return $grid;
	}
}
