<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Customer\Loyalty;

use Core\AdminModule\Model\Sites;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\AdminModule\Model\LoyaltyService;
use EshopOrders\Model\Entities\Customer;
use EshopOrders\Model\Loyalty\LoyaltyPointsManager;
use Exception;
use Nette\Utils\ArrayHash;

class LoyaltyPointsForm extends BaseControl
{
	public function __construct(
		protected Customer             $customer,
		protected LoyaltyPointsManager $loyaltyPointsManager,
		protected LoyaltyService       $loyaltyService,
		protected Sites                $sites,
	)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setShowLangSwitcher(false);

		$form->addText('points', 'eshopOrders.loyalty.points')
			->setRequired()
			->setHtmlType('number')
			->setHtmlAttribute('step', 1);
		$form->addText('reason', 'eshopOrders.loyalty.reason')
			->setRequired()
			->setMaxLength(255);
		$form->addSelect('site', 'eshopOrders.loyalty.site', $this->sites->getOptionsForSelect());
		$form->addTextArea('note', 'eshopOrders.loyalty.note');

		$form->addSubmit('save', 'eshopOrders.loyalty.addPoints');

		$form->onSuccess[] = $this->formSuccess(...);

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		try {
			$this->loyaltyPointsManager->modify(
				points    : (int) $values->points,
				customerId: $this->customer->getId(),
				siteIdent : $values->site,
				reason    : $values->reason,
				note      : $values->note,
			);

			$this->presenter->flashMessageSuccess('default.saved');
		} catch (Exception $e) {
			$form->addError($e->getMessage());
			$this->redrawControl('form');

			return false;
		}

		$this->redirect('this');
	}
}
