<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Customer\Loyalty;

use Core\Model\Helpers\Strings;
use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use Core\Model\UI\DataGrid\DataSource\DoctrineDataSource;
use Doctrine\ORM\Query\Expr\Join;
use Doctrine\ORM\QueryBuilder;
use EshopOrders\AdminModule\Model\LoyaltyService;
use EshopOrders\Model\Entities\Customer;
use EshopOrders\Model\Entities\CustomerAddress;
use EshopOrders\Model\Entities\CustomerLoyaltyAction;
use EshopOrders\Model\Entities\GroupCustomers;
use EshopOrders\Model\EshopOrdersConfig;
use Nette\Utils\Html;

class LoyaltyPointsGrid extends BaseControl
{
	public function __construct(
		protected Customer       $customer,
		protected string         $siteIdent,
		protected LoyaltyService $loyaltyService,
	)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();
		$grid->setStrictStorageFilterValues(false);

		$qb         = $this->em->getRepository(CustomerLoyaltyAction::class)->createQueryBuilder('la')
			->innerJoin('la.customerLoyalty', 'l', Join::WITH, 'l.customer = :customer')
			->setParameter('customer', $this->customer->getId())
			->orderBy('la.createdAt', 'DESC');
		$dataSource = new DoctrineDataSource($qb, 'la.id');

		$grid->setDataSource($dataSource);

		//Columns
		$createdAtColumn = $grid->addColumnDateTime('createdAt', 'eshopOrders.loyalty.createdAt')
			->setFormat('Y-m-d H:i');
		$createdAtColumn->getElementPrototype('td')->addClass('w1nw');

		$pointsColumn = $grid->addColumnNumber('points', 'eshopOrders.loyalty.points')
			->setFormat(0, '', ' ')
			->setAlign('right');
		$pointsColumn->getElementPrototype('th')->addClass('w1nw');
		$pointsColumn->getElementPrototype('td')->addClass('w1nw');

		$reasonColumn = $grid->addColumnText('reason', 'eshopOrders.loyalty.reason');

		$referenceColumn = $grid->addColumnText('reference', 'eshopOrders.loyalty.reference')
			->setRenderer(function(CustomerLoyaltyAction $row) {
				if (!$row->referenceId) {
					return '';
				}

				return Html::el('a', [
					'href' => $this->presenter->link(':EshopOrders:Admin:Default:editOrder', ['id' => $row->referenceId]),
				])->setText($row->referenceId);
			})
			->setAlign('right');
		$referenceColumn->getElementPrototype('td')->addClass('w1nw');

		$noteColumn = $grid->addColumnText('note', 'eshopOrders.loyalty.note')
			->setRenderer(function(CustomerLoyaltyAction $row) {
				return Html::el()->setHtml($row->note ? nl2br($row->note) : '');
			});

		return $grid;
	}
}
