<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\DashboardWidgets;

use Core\Model\Templating\Filters\Price as PriceFilter;
use Currency\Model\Currencies;
use Dashboard\AdminModule\Components\Widget;
use Nette\DI\Attributes\Inject;

abstract class BaseEshopOrdersWidget extends Widget
{
	#[Inject]
	public Currencies $currencies;

	#[Inject]
	public PriceFilter $priceFilter;

	protected string $baseTemplate = __DIR__ . '/baseCount.latte';

	protected function getCurrencySymbol(): string { return (string) $this->currencies->getAll()[$this->currencies->getDefaultCode()]->symbol ?: 'Kč'; }
}
