<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Invoice;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use EshopOrders\Model\Entities\InvoiceConfig;
use EshopOrders\Model\Entities\SellerInvoiceConfig;
use EshopOrders\Model\InvoiceConfigRepository;
use EshopOrders\Model\Invoices;
use Nette\Utils\Html;

class InvoiceConfigsGrid extends BaseControl
{
	public function __construct(
		protected InvoiceConfigRepository $invoiceConfigs,
		protected Invoices                $invoices,
	)
	{
	}

	public function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();
		$grid->setDataSource($this->invoiceConfigs->getQueryBuilder());

		$grid->addColumnText('sellers', 'eshopOrders.invoiceConfigsGrid.sellers')
			->setRenderer(static function(InvoiceConfig $config): Html {
				$html = Html::el();

				foreach ($config->sellerInvoiceConfigs->toArray() as $sellerConfig) {
					$html->addHtml(Html::el('div')->setText($sellerConfig->seller->title));
				}

				return $html;
			});

		$grid->addColumnText('maturity', 'eshopOrders.invoiceConfigsGrid.maturity');
		$grid->addColumnText('prefix', 'eshopOrders.invoiceConfigsGrid.numericalSeries.default.prefix')
			->setRenderer(static fn(InvoiceConfig $config): string => $config->numericalSeries->prefix);
		$grid->addColumnText('digitsCount', 'eshopOrders.invoiceConfigsGrid.numericalSeries.default.digitsCount')
			->setRenderer(static fn(InvoiceConfig $config): int => $config->numericalSeries->digitsCount);
		$grid->addColumnText('startNumber', 'eshopOrders.invoiceConfigsGrid.numericalSeries.default.startNumber')
			->setRenderer(static fn(InvoiceConfig $config): int => $config->numericalSeries->startNumber);

		$grid->addAction('edit', '', ':invoiceSettings!', ['itemId' => 'id'])
			->addClass('ajax')
			->setIcon('edit')->setBsType('primary');

		$grid->addAction('remove', '', 'remove!', ['itemId' => 'id'])
			->setRenderCondition(fn(InvoiceConfig $config): bool => $this->invoices->getIvoicesCount($this->getSellersId($config->sellerInvoiceConfigs->toArray())) === 0)
			->addClass('ajax')
			->setIcon('trash')
			->setBsType('danger')
			->setConfirm('default.reallyDelete');

		return $grid;
	}

	public function handleRemove(mixed $itemId): void
	{
		$this->invoiceConfigs->remove((int) $itemId);
		$this['grid']->reload();
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	public function getSellersId(array $sellers): array
	{
		return array_map(static fn(SellerInvoiceConfig $config): int => $config->seller->getId(), $sellers);
	}
}
