<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderFlag;

class MarketingInfo extends BaseControl
{
	protected Order $order;

	public function __construct(
		Order $order
	)
	{
		$this->order = $order;
	}

	public function render(): void
	{
		if (!$this->loggedUser->isAllowed('EshopOrders', 'showMarketingInfo')) {
			return;
		}

		$this->template->flags = [
			OrderFlag::TYPE_NEWSLETTER,
			OrderFlag::TYPE_QUESTIONING,
			OrderFlag::typeZboziConversion,
			OrderFlag::typeEcomailOrder,
		];
		$this->template->data  = $this->getData();
		$this->template->render($this->getTemplateFile());
	}

	protected function getData(): array
	{
		$result = [];

		foreach ($this->order->getOrderFlags() as $flag) {
			$result[$flag->getType()] = [
				'state' => $flag->getState(),
			];
		}

		return $result;
	}
}
