<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\EshopOrdersConfig;
use Nette\Utils\ArrayHash;

class OrderSettings extends BaseControl
{
	protected Order $order;

	public function __construct(
		Order $order
	)
	{
		$this->order = $order;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setShowLangSwitcher(false);
		$form->setAjax();

		if (EshopOrdersConfig::load('orderForm.allowEditType')) {
			$form->addSelect('type', 'eshopOrders.orderType.title', ['' => ''] + (array) EshopOrdersConfig::load('orderForm.typeList'))
				->setDefaultValue($this->order->type);
		}

		$form->addSubmit('save', 'default.save');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		try {
			if (EshopOrdersConfig::load('orderForm.allowEditType')) {
				$this->order->type = $values->type ?: null;
			}

			$this->em->persist($this->order);
			$this->em->flush();

			$this->presenter->flashMessageSuccess('default.saved');
			$this->presenter->redrawControl('flashes');

			$this->redrawControl('form');
		} catch (\Exception $e) {
			$this->presenter->flashMessageDanger('default.error');
			$this->presenter->redrawControl('flashes');

			$form->addError($e->getMessage());
			$this->redrawControl('form');
		}
	}
}
