<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components;

use Core\AdminModule\Components\DataForm;
use Core\AdminModule\Model\Sites;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\CacheService;
use EshopOrders\Model\EshopOrdersConfig;
use EshopOrders\Model\Loyalty\LoyaltySettings;
use Nette\Utils\ArrayHash;
use Override;

class SettingsForm extends DataForm
{

	public function __construct(
		public Sites           $sitesService,
		protected CacheService $cacheService,
	)
	{
		parent::__construct();
	}

	#[Override]
	public function getDataForInputs(): array
	{
		$data = parent::getDataForInputs();

		foreach ($this->sitesService->getOptionsForSelect() as $site) {
			$data[] = [
				'name'      => $site . 'ReviewInformationPage',
				'title'     => [
					0 => 'eshopOrders.settings.reviewInformationPage',
				],
				'type'      => 'navByGroup',
				'showIf'    => EshopOrdersConfig::load('enableReviewInformationPage', false),
				'site'      => $site,
				'section'   => $site,
				'group'     => 'base',
				'groupName' => 'eshopOrders.settings.baseSettings',
			];
			$data[] = [
				'name'    => $site . 'PageAfterRegister',
				'title'   => [
					0 => 'eshopOrders.settings.customer.pageAfterRegister',
				],
				'type'    => 'navByGroup',
				'site'    => $site,
				'section' => $site,
			];

			if (EshopOrdersConfig::load('allowLoyaltyPoints')) {
				$key   = $site . 'LoyaltyPoints';
				$title = 'eshopOrders.settings.loyaltyPoints.';
				$group = 'loyaltyPoints';
				$data  = array_merge($data, [
						[
							'name'      => $key . 'Enable',
							'title'     => [
								0 => $title . 'enable',
							],
							'type'      => 'bool',
							'site'      => $site,
							'section'   => $site,
							'group'     => $group,
							'groupName' => $title . 'group',
						], [
							'name'    => $key . 'RegistrationPoints',
							'title'   => [
								0 => $title . 'registrationPoints',
							],
							'type'    => 'number',
							'site'    => $site,
							'section' => $site,
							'group'   => $group,
						], [
							'name'    => $key . 'ReviewPoints',
							'title'   => [
								0 => $title . 'reviewPoints',
							],
							'type'    => 'number',
							'site'    => $site,
							'section' => $site,
							'group'   => $group,
						], [
							'name'    => $key . 'MaxReviewsPerOrder',
							'title'   => [
								0 => $title . 'maxReviewsPerOrder',
							],
							'type'    => 'number',
							'site'    => $site,
							'section' => $site,
							'group'   => $group,
						], [
							'name'    => $key . 'WholeMoneyValueForPoint',
							'title'   => [
								0 => $title . 'wholeMoneyValueForPoint',
							],
							'type'    => 'number',
							'site'    => $site,
							'section' => $site,
							'group'   => $group,
						], [
							'name'    => $key . 'PointsForWholeMoney',
							'title'   => [
								0 => $title . 'pointsForWholeMoney',
							],
							'type'    => 'number',
							'site'    => $site,
							'section' => $site,
							'group'   => $group,
						], [
							'name'    => $key . 'MinimalOrderValue',
							'title'   => [
								0 => $title . 'minimalOrderValue',
							],
							'type'    => 'number',
							'site'    => $site,
							'section' => $site,
							'group'   => $group,
						], [
							'name'    => $key . 'MaxOrderPercent',
							'title'   => [
								0 => $title . 'maxOrderPercent',
							],
							'type'    => 'number',
							'site'    => $site,
							'section' => $site,
							'group'   => $group,
						], [
							'name'    => $key . 'OneMoneyForPoints',
							'title'   => [
								0 => $title . 'oneMoneyForPoints',
							],
							'type'    => 'number',
							'site'    => $site,
							'section' => $site,
							'group'   => $group,
						], [
							'name'    => $key . 'PointsExpire',
							'title'   => [
								0 => $title . 'pointsExpire',
							],
							'type'    => 'number',
							'site'    => $site,
							'section' => $site,
							'group'   => $group,
						], [
							'name'    => $key . 'EmailBeforeExpireDays',
							'title'   => [
								0 => $title . 'emailBeforeExpireDays',
							],
							'type'    => 'number',
							'site'    => $site,
							'section' => $site,
							'group'   => $group,
						], [
							'name'    => $key . 'Name',
							'title'   => [
								0 => $title . 'name',
							],
							'type'    => 'text',
							'site'    => $site,
							'section' => $site,
							'group'   => $group,
						], [
							'name'    => $key . 'Icon',
							'title'   => [
								0 => $title . 'icon',
							],
							'type'    => 'file',
							'site'    => $site,
							'section' => $site,
							'group'   => $group,
						],
					]
				);
			}
		}

		return $data;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		$result = parent::formSuccess($form, $values);

		$this->cacheService->loyaltyCache->clearSettings();

		return $result;
	}

}
