<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model\Dao;

use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderAddress;

class OrderExpedition
{
	public array $siteColors = [];

	public function __construct(
		public Order   $order,
		public string  $serviceName,
		public ?object $expeditionEntity = null,
	)
	{
	}

	public function getOrderId(): int { return $this->order->getId(); }

	public function getCustomerName(): ?string
	{
		$address = $this->order->getAddressInvoice();
		if (!$address instanceof OrderAddress) {
			return null;
		}

		return trim($address->getFirstName() . ' ' . $address->getLastName());
	}

	public function getCustomerCity(): ?string
	{
		return $this->order->getAddressDelivery()?->getCity();
	}

	public function getSitePrimaryColor(): string { return $this->siteColors['primaryColor'] ?? '#000000'; }
}
