<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Entities\EntityManagerDecorator;

class LoyaltyService
{

	public function __construct(
		protected EntityManagerDecorator $em,
	)
	{
	}

	public function getLoyaltyPoints(int $customerId): array
	{
		$conn = $this->em->getConnection();

		$result = [];

		foreach ($conn->fetchAllAssociative("SELECT site_id, points FROM eshop_orders__customer_loyalty WHERE customer_id = :customerId", [
			'customerId' => $customerId,
		]) as $row) {
			$result[$row['site_id']] = (int) $row['points'];
		}

		return $result;
	}
}
