<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Contributte\Scheduler\Helpers\Debugger;
use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\OrderGift;
use Exception;

/**
 * @method OrderGift|object|null getReference($id)
 * @method OrderGift[]|null getAll()
 * @method OrderGift|null get($id)
 */
class OrderGifts extends BaseEntityService
{
	protected $entityClass = OrderGift::class;

	public function setReadyToDelivery(int $id, int $value): bool
	{
		try {
			$oi = $this->get($id);

			if (!$oi) {
				return false;
			}

			$oi->isReadyToDelivery = $value;
			$this->em->persist($oi);
			$this->em->flush();

			return true;
		} catch (Exception $e) {
			Debugger::log($e);

			return false;
		}
	}

}
