<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\OrderItemReview;
use EshopOrders\Model\Helpers\EshopOrdersCache;
use Exception;
use Nette\Caching\Cache;
use Tracy\Debugger;

/**
 * @method OrderItemReview|null getReference($id)
 * @method OrderItemReview|null get($id)
 */
class OrderItemReviews extends BaseEntityService
{
	protected $entityClass = OrderItemReview::class;

	public function __construct(
		protected EshopOrdersCache $eshopOrdersCache,
	)
	{
	}

	public function changeStatus(string $status, int $id): bool
	{
		try {
			if (!in_array($status, OrderItemReview::STATUSES)) {
				return false;
			}

			$this->em->beginTransaction();

			$review = $this->getReference($id);
			if ($review) {
				if ($status === OrderItemReview::STATUS_TOP) {
					$orderItemReviewTable = 'eshop_orders__order_item_review';
					$orderItemTable       = 'eshop_orders__order_item';
					$this->em->getConnection()
						->executeQuery(sprintf("UPDATE %s JOIN %s ON %s.order_item_id = %s.id SET %s.status = ? WHERE %s.status = ? AND %s.product_id = ?", $orderItemReviewTable, $orderItemTable, $orderItemReviewTable, $orderItemTable, $orderItemReviewTable, $orderItemReviewTable, $orderItemTable), [OrderItemReview::STATUS_PUBLISHED,
							OrderItemReview::STATUS_TOP, $review->orderItem->getProductId()]);
				}

				$review->status = $status;
				$this->em->persist($review);
				$this->em->flush();
				$this->em->commit();

				$this->eshopOrdersCache->getCache()->clean([
					Cache::Tags => ['productReviews/' . $review->orderItem->getProductId()],
				]);

				return true;
			}

			return false;
		} catch (Exception $ex) {
			Debugger::log($ex);
			$this->em->rollback();

			return false;
		}
	}

}
