<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Components\Affiliate\CampaignsGrid;
use EshopOrders\AdminModule\Components\Affiliate\ICampaignsGridFactory;
use EshopOrders\AdminModule\Components\Affiliate\IOrdersGridFactory;
use EshopOrders\AdminModule\Components\Affiliate\IPartnersGridFactory;
use EshopOrders\AdminModule\Components\Affiliate\OrdersGrid;
use EshopOrders\AdminModule\Components\Affiliate\PartnersGrid;

class AffiliatePresenter extends BasePresenter
{
	public function actionDefault(): void
	{
		$this->setHeader('eshopOrders.menu.affiliate', 'fa fa-user');

		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopOrders.affiliate.addCampaign',
				'link'  => $this->link('campaignsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			], [
				'title' => 'eshopOrders.affiliate.addPartner',
				'link'  => $this->link('partnersGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	protected function createComponentCampaignsGrid(ICampaignsGridFactory $factory): CampaignsGrid { return $factory->create(); }

	protected function createComponentPartnersGrid(IPartnersGridFactory $factory): PartnersGrid { return $factory->create(); }

	protected function createComponentOrdersGrid(IOrdersGridFactory $factory): OrdersGrid { return $factory->create(); }
}
