<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopCatalog\AdminModule\Model\Suppliers;
use EshopOrders\AdminModule\Components\SupplierToOrder\ISupplierGridFactory;
use EshopOrders\AdminModule\Components\SupplierToOrder\SupplierGrid;
use Nette\Application\UI\Multiplier;
use Override;

class SupplierToOrderPresenter extends BasePresenter
{
	public function __construct(
		protected Suppliers $suppliers,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function startup(): void
	{
		parent::startup();
		$this->setHeader('eshopOrders.menu.supplierToOrder', 'fas fa-truck-loading');
	}

	public function actionDefault(): void
	{
		$this->template->suppliers = $this->suppliers->getOptionsForSelect();

		$this['navigation']->setData(['header' => [
		]]);
	}

	protected function createComponentSuppliersGrid(ISupplierGridFactory $factory): Multiplier
	{
		return new Multiplier(fn(string $supplierId): SupplierGrid => $factory->create((int) $supplierId));
	}
}
