<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Http\ApiResponse;
use Apitte\Core\UI\Controller\IController;
use Apitte\Negotiation\Http\ArrayEntity;

/**
 * @Path ("/api/v1/eshoporders")
 */
abstract class BaseController implements IController
{
	public function sendError(ApiResponse $response, string $message, int $code = 404): ApiResponse
	{
		$response = $response->withStatus($code)
			->withEntity(ArrayEntity::from([
				'status'  => 'error',
				'message' => $message,
			]));

		return $response;
	}
}
