<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Tracy\Debugger;

/**
 * @Path("/nexgo-terminal-log")
 */
class NexgoTerminalLogController extends BaseController
{
	/**
	 * @Path("/log")
	 * @Method("POST")
	 */
	public function log(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		Debugger::log($request->getJsonBody(), 'nexgo-terminal-log');

		return $response;
	}

}