<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Model\Dao;

use DateTimeInterface;

class Order
{
	public ?int               $customerId      = null;
	public ?string            $firstName       = null;
	public ?string            $lastName        = null;
	public ?string            $email           = null;
	public ?string            $phone           = null;
	public ?int               $customerGroupId = null;
	public bool               $agreedTerms     = false;
	public ?DateTimeInterface $paid            = null;
	public ?string            $message         = null;
	public ?Address           $deliveryAddress = null;
	public ?Address           $invoiceAddress  = null;
	public ?OrderPayment      $payment         = null;
	public ?OrderSpedition    $spedition       = null;

	/** @var OrderItem[] */
	public array $items = [];

	/** @var OrderDiscount[] */
	public array $discounts = [];

	/** @var OrderStatus[] */
	public array $statuses = [];

	/** @var OrderFlag[] */
	public array $flags = [];

	/** @var OrderGift[] */
	public array $gifts = [];

	public function __construct(
		public int    $id,
		public string $ident,
		public string $eshopId,
		public string $lang,
		public float  $price,
		public float  $priceWithoutVat,
	)
	{
	}
}
