<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Helpers\Arrays;
use Core\Model\Sites;
use EshopOrders\Model\Entities\Payment;

class Payments
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected Sites                  $sites,
	)
	{
	}

	/**
	 * @return Dao\Payment[]
	 */
	public function getAll(): array
	{
		$result        = [];
		$currentDomain = 'https://' . $this->sites->getCurrentSite()->getCurrentDomain()->getDomain();

		foreach ($this->em->getRepository(Payment::class)->createQueryBuilder('p')
			         ->select('p.id, p.name, p.ident, p.price, p.text, p.isPublished, p.position,
						p.freeFrom, p.availableFrom, p.availableTo, p.image')
			         ->orderBy('p.position', 'ASC')
			         ->getQuery()->getArrayResult() as $row) {
			$row['price'] = (float) $row['price'];

			if ($row['image']) {
				$row['image'] = $currentDomain . $row['image'];
			}

			if ($row['availableTo'] === 999999) {
				$row['availableTo'] = null;
			}

			$dao = new Dao\Payment($row['id'], $row['name'], (string) $row['ident'], $row['price']);
			Arrays::setObjectVars($dao, $row);

			$result[$row['id']] = $dao;
		}

		return $result;
	}
}
