<?php declare(strict_types = 1);

namespace EshopOrders\ApiModule\Api\V1\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Helpers\Arrays;
use Core\Model\Sites;
use EshopOrders\Model\Entities\Spedition;
use EshopOrders\Model\Entities\SpeditionWeight;
use EshopOrders\Model\EshopOrdersConfig;

class Speditions
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected Sites                  $sites,
	)
	{
	}

	/**
	 * @return Dao\Spedition[]
	 */
	public function getAll(): array
	{
		$result        = [];
		$currentDomain = 'https://' . $this->sites->getCurrentSite()->getCurrentDomain()->getDomain();

		$qb = $this->em->getRepository(Spedition::class)->createQueryBuilder('s')
			->select('s.id, s.name, s.ident, s.code1, s.code2, s.isPickup, s.allowOversized, s.showOnlyIfOversizedProductInCart, s.price, s.text, s.isPublished, s.position,
						s.freeFrom, s.availableFrom, s.availableTo, s.image, s.zboziId, s.heurekaId, s.googleId')
			->orderBy('s.position', 'ASC');

		if (EshopOrdersConfig::load('speditions.allowWeights')) {
			$qb->addSelect('s.maxWeight');
		}

		foreach ($qb->getQuery()->getArrayResult() as $row) {
			$row['price'] = (float) $row['price'];

			if ($row['image']) {
				$row['image'] = $currentDomain . $row['image'];
			}

			if ($row['availableTo'] === 999999) {
				$row['availableTo'] = null;
			}

			if (isset($row['maxWeight'])) {
				$row['maxWeight'] = (float) $row['maxWeight'];
			}

			$dao = new Dao\Spedition($row['id'], $row['name'], (string) $row['ident'], $row['price']);
			Arrays::setObjectVars($dao, $row);
			bdump($row);
			bdump($dao);

			$result[$row['id']] = $dao;
		}

		if (EshopOrdersConfig::load('speditions.allowWeights')) {
			foreach ($this->em->getRepository(SpeditionWeight::class)->createQueryBuilder('sw')
				         ->select('IDENTITY(sw.spedition) as spedition, sw.weightFrom, sw.price')
				         ->orderBy('sw.weightFrom', 'ASC')
				         ->getQuery()->getArrayResult() as $row) {
				$dao = new Dao\SpeditionWeight((float) $row['weightFrom'], (float) $row['price']);

				$result[$row['spedition']]->weights[(string) $row['weightFrom']] = $dao;
			}
		}

		return $result;
	}
}
