<?php declare(strict_types = 1);

namespace EshopOrders\Console\Cart;

use Doctrine;
use EshopOrders\AdminModule\Model\Carts;
use Exception;
use Override;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'eshoporders:cart:clean')]
class Clean extends Command
{

	public function __construct(
		public Carts $carts,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function configure(): void
	{
		$this->setName('eshoporders:cart:clean')->setDescription('Clean inactive carts');
	}

	#[Override]
	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('CLEAR INACTIVE CARTS');

		try {
			$this->carts->removeInactive();

			$output->writeLn('<info>[OK] - carts cleaned</info>');
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 0;
	}
}
