<?php declare(strict_types = 1);

namespace EshopOrders\CronModule\Presenters;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Query\Parameter;
use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\ORM\Query\Expr\Join;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderStatus;
use EshopOrders\Model\EshopOrdersConfig;
use Nette\Security\Passwords;
use Nette\Utils\DateTime;
use Nette\Utils\Strings;

class CustomersPresenter extends BasePresenter
{
	public function __construct(
		protected EntityManagerDecorator $em
	)
	{
		parent::__construct();
	}

	public function actionFilterByOrders(
		string $key,
		string $siteIdent,
		string $from,
		string $to
	): void
	{
		$fromDate = DateTime::createFromFormat('Y-m-d', $from);
		$toDate   = DateTime::createFromFormat('Y-m-d', $to);

		if (!$fromDate || !$toDate) {
			$this->error();
		}

		$fromDate->setTime(0, 0, 0);
		$toDate->setTime(23, 59, 59);

		$password  = new Passwords();
		$keyVerify = $password->verify(EshopOrdersConfig::loadString('cronUrlHash') . $siteIdent, $key);

		if (!$keyVerify) {
			$this->error();
		}

		header('Content-Encoding: UTF-8');
		header("content-type:application/csv;charset=UTF-8");
		header("Content-Disposition:attachment;filename=\"uzivatele.csv\"");
		header('Content-Transfer-Encoding: binary');

		$fp = fopen('php://output', 'wb');

		if (!$fp) {
			$this->error();
		}

		fwrite($fp, "\xEF\xBB\xBF");

		foreach ($this->em->getRepository(Order::class)->createQueryBuilder('o')
			         ->select('o.id, inv.firstName, inv.lastName, inv.email, IDENTITY(inv.country) as country')
			         ->innerJoin('o.orderStatuses', 'os', Join::WITH, 'os.status = :status AND os.created >= :from AND os.created <= :to')
			         ->innerJoin('o.addressInvoice', 'inv')
			         ->where('o.site = :siteIdent')
			         ->setParameters(new ArrayCollection([new Parameter('siteIdent', $siteIdent), new Parameter('status', OrderStatus::STATUS_CREATED), new Parameter('from', $from), new Parameter('to', $to)]))->groupBy('inv.email')
			         ->orderBy('o.id', 'ASC')
			         ->getQuery()->getArrayResult() as $row) {
			fputcsv($fp, [
				$row['firstName'],
				$row['lastName'],
				$row['email'],
				$row['country'] ? Strings::upper($row['country']) : '',
			], ';');
		}

		fclose($fp);

		exit;
	}
}
