<?php declare(strict_types = 1);

namespace EshopOrders\DI;

use Core\DI\CompilerExtension;
use Nette\DI\Definitions\ServiceDefinition;
use Nette\DI\Definitions\Statement;
use Nette\DI\MissingServiceException;
use Nette\PhpGenerator\ClassType;
use Override;

class EshopOrdersExtension extends CompilerExtension
{

	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));;

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['EshopOrders' => 'EshopOrders\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		try {
			/** @var ServiceDefinition $cartHelper */
			$cartHelper = $builder->getDefinition('eshopOrders.cartHelper');
			$cartHelper->addSetup(new Statement('$service->setOrderSales(?)', [$builder->getDefinition('eshopSales.front.orderSales')]));
		} catch (MissingServiceException) {
		}
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->getMethod('initialize');
		$this->getContainerBuilder();

		$init->addBody('EshopOrders\Model\EshopOrdersConfig::setParams($this->parameters[\'eshopOrders\']);');
		$init->addBody('EshopOrders\Model\Helpers\FormValidator::$pscHelper = $this->getService(\'eshopOrders.helper.psc\');');
	}
}
