<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Customer\Loyalty;

use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\LoyaltyService;
use EshopOrders\Model\Entities\Customer;

class PointsHistory extends BaseControl
{
	public function __construct(
		protected ?Customer      $customer,
		protected LoyaltyService $loyaltyService,
	)
	{
	}

	public function render(): void
	{
		if (!$this->customer) {
			return;
		}

		$this->template->pointsHistory = $this->loyaltyService->findLastPointsHistory($this->customer->getId());
		$this->template->render($this->getTemplateFile());
	}
}

