<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Order;

use Core\Model\Event\ComponentTemplateEvent;
use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\CartFacade;
use EshopOrders\FrontModule\Model\Speditions;
use EshopOrders\Model\Payments;

class OrderSummary extends BaseControl
{
	protected array $orderData = [];

	public function __construct(
		protected Speditions $speditionsService,
		protected Payments   $paymentsService,
		public CartFacade    $cartFacade,
	)
	{
	}

	public function render(): void
	{
		$this->template->orderData = $this->getOrderData();
		$this->template->cart      = $this->cartFacade->getCart();

		$this->eventDispatcher->dispatch(new ComponentTemplateEvent($this->template, $this), 'eshopOrders.orderSummary.render');

		$this->template->render($this->getTemplateFile());
	}

	public function setParameters(array $orderData): self
	{
		$this->orderData = $orderData;

		return $this;
	}

	public function getOrderData(): array { return $this->orderData ?: $this->cartFacade->getOrderFormData(); }
}

