<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use EshopCatalog\FrontModule\Model\Dao\Product;

class CartItemGift
{
	protected int     $productId;
	public ?string    $code1 = null;
	public ?string    $ean   = null;
	protected ?string $name  = null;

	public function __construct(
		protected Product $product,
		?string           $name = null
	)
	{
		$this->productId = $this->product->getId();
		$this->name      = $name ?: $this->product->getName();
		$this->code1     = $this->product->getCode1();
		$this->ean       = $this->product->getEan();
	}

	public function getProductId(): int { return $this->productId; }

	public function getName(): string { return $this->name; }
}
