<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use Core\Model\Application\AppState;
use EshopOrders\Model\Entities\IDiscount;
use Override;

class Discount implements IDiscount
{
	public ?string $title                  = null;
	public ?string $description            = null;
	public ?float  $amountInBaseCurrency   = null;
	public float   $discountInBaseCurrency = 0;
	public float   $discount               = 0;
	public string  $typeSymbol             = '';

	public ?string $text = null;

	/** @var callable|null */
	public $calculateDiscountCallback;

	public function __construct(
		public ?string $id,
		public ?float  $amount,
		public string  $type,
		public ?string $packageType,
	)
	{
	}

	public function calculateDiscount(): float
	{
		if (is_callable($this->calculateDiscountCallback)) {
			return call_user_func($this->calculateDiscountCallback, $this);
		}

		return round($this->discount, (int) AppState::getState('eshopOrdersCartDecimals', 0));
	}

	#[Override]
	public function getValue(): float
	{
		return $this->amount;
	}

	#[Override]
	public function getType(): string
	{
		return $this->type;
	}
}



