<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use EshopOrders\Model\EshopOrdersConfig;
use EshopOrders\Model\Helpers\OrderItemReviewsHelper;
use Nette\Utils\DateTime;

class ProductReview
{
	public DateTime $created;
	public float    $maxRating;

	public function __construct(
		public string  $customer,
		DateTime       $created,
		public float   $rating,
		public ?string $description
	)
	{
		$this->created   = DateTime::from($created);
		$this->maxRating = self::getMaxRating();
	}

	/**
	 * @return float[]
	 */
	public function getRatingAsArray(bool $withBlanks = false): array
	{
		return OrderItemReviewsHelper::ratingToArray($this->rating, $withBlanks);
	}

	public static function getMaxRating(): float
	{
		return (float) EshopOrdersConfig::load('orderItemReviews.maxRating');
	}
}
